<?php

use \UtillzCore\Inc\Src\Request\Request;

defined('ABSPATH') || exit;

$is_business = get_user_meta( get_current_user_id(), 'ulz_role', true ) == 'business';
$entries = \UtillzCore\Inc\Src\Woocommerce\Account\Account::get_entries( ( isset( $_GET['type'] ) || ! $is_business ) ? 'outgoing' : 'ingoing' );
$request = Request::instance();
$page = $request->has('onpage') ? $request->get('onpage') : 1;

?>

<?php if( $is_business ): ?>

    <div class="ulz-boxes-tabs">
        <ul>
            <li class="<?php if( ! isset( $_GET['type'] ) ) { echo 'ulz--active'; } ?>">
                <a href="<?php echo esc_url( wc_get_account_endpoint_url( 'entries' ) ); ?>">
                    <?php esc_html_e( 'Incoming', 'utillz-core' ); ?>
                </a>
            </li>
            <li class="<?php if( isset( $_GET['type'] ) ) { echo 'ulz--active'; } ?>">
                <a href="<?php echo esc_url( add_query_arg([ 'type' => 'outgoing' ], wc_get_account_endpoint_url( 'entries' ) ) ); ?>">
                    <?php esc_html_e( 'Outgoing', 'utillz-core' ); ?>
                </a>
            </li>
        </ul>
    </div>

    <?php if( ! isset( $_GET['type'] ) ): ?>
        <p><?php esc_html_e( 'Entries that you have recieved from other users', 'utillz-core' ); ?></p>
    <?php else: ?>
        <p><?php esc_html_e( 'Entries that you have sent to other users', 'utillz-core' ); ?></p>
    <?php endif; ?>

<?php endif; ?>

<?php if( $entries->have_posts() ): ?>
    <div class="ulz-boxes">
        <?php while( $entries->have_posts() ) : $entries->the_post(); ?>
            <?php Ucore()->the_template('account/entries/row'); ?>
        <?php endwhile; wp_reset_postdata(); ?>
    </div>
<?php else: ?>
    <p><strong><?php esc_html_e( 'No entries were found', 'utillz-core' ); ?></strong></p>
<?php endif; ?>

<div class="ulz-paging">
    <?php
        echo Ucore()->pagination([
            'base' => add_query_arg( [ 'onpage' => '%#%' ], wc_get_account_endpoint_url( 'entries' ) ),
            'format' => '?onpage=%#%',
            'current' => $page,
            'total' => $entries->max_num_pages,
        ]);
    ?>
</div>

<?php Ucore()->the_template('modals/entry-edit/content'); ?>
<?php Ucore()->the_template('modals/review/content'); ?>
